<?php
use Illuminate\Support\Facades\Auth;

return [
    // SIDEBAR ITEMS:
    'menu' => [
        [
            'text' => 'dashboard.dashboard',
            'route' => 'dashboard',
            'header' => false,
            'icon' => 'nav-icon fas fa-tachometer-alt',
            'can' => ['dashboard'],
        ],
        [
            'text' => 'dashboard.registration',
            'header' => true,
        ],
        [
            'text' => 'dashboard.members',
            'icon' => 'nav-icon fas fa-user',
            'can' => ['member.create', 'member.index', 'member.edit'],
            'header' => false,
            'submenu' => [
                [
                    'text' => 'dashboard.add_member',
                    'route' => 'member.create',
                ],
                [
                    'text' => 'dashboard.view_members',
                    'route' => 'member.index',
                ],
            ],
        ],
        [
            'text' => 'dashboard.membership_plans',
            'can' => ['plan.index', 'plan.create', 'plan.edit'],
            'icon' => 'nav-icon fas fa-calendar-alt',
            'header' => false,
            'submenu' => [
                [
                    'text' => 'dashboard.add_plan',
                    'route' => 'plan.create',
                ],
                [
                    'text' => 'dashboard.plans',
                    'route' => 'plan.index',
                ],
            ],
        ],
        [
            'text' => 'dashboard.memberships', 
            'icon' => 'nav-icon fas fa-file-invoice',
            'can' => ['membership.index', 'transaction.create', 'membership.create', 'invoice.show', 'invoice.print'],
            'header' => false,
            'submenu' => [
                [
                    'text' => 'dashboard.assign_membership',
                    'route' => 'membership.create',
                ],
                [
                    'text' => 'dashboard.membership_payments',
                    'route' => 'membership.index',
                ],
            ],
        ],
        [
            'text' => 'dashboard.general',
            'header' => true,
        ],
        [
            'text' => 'dashboard.notifications',
            'can' => ['member.unpaid', 'member.expired'],
            'icon' => 'nav-icon fas fa-bell',
            'header' => false,
            'submenu' => [
                [
                    'text' => 'dashboard.unpaid_members',
                    'route' => 'member.unpaid',
                ],
                [
                    'text' => 'dashboard.ending_memberships',
                    'route' => 'member.expired',
                ],
            ],
        ],
        [
            'text' => 'dashboard.other_income', 
            'icon' => 'nav-icon fas fa-plus-square',
            'can' => ['income.index', 'income.create','income.edit'], 
            'header' => false,
            'submenu' => [
                [
                    'text' => 'dashboard.add_income',
                    'route' => 'income.create',
                ],
                [
                    'text' => 'dashboard.view_income',
                    'route' => 'income.index',
                ],
            ],
        ],
        [
            'text' => 'dashboard.expenses', 
            'icon' => 'nav-icon fas fa-minus-square',
            'can' => ['expense.index', 'expense.create','expense.edit'],
            'header' => false,
            'submenu' => [
                [
                    'text' => 'dashboard.add_expenses',
                    'route' => 'expense.create',
                ],
                [
                    'text' => 'dashboard.view_expenses',
                    'route' => 'expense.index',
                ],
            ],
        ],
        [
            'text' => 'dashboard.attendance',
            'icon' => 'nav-icon fas fa-address-book',
            'can' => ['attendance.create', 'attendance.index'],
            'header' => false,
            'submenu' => [
                [
                    'text' => 'dashboard.manual_attendance',
                    'route' => 'attendance.create',
                ],
                [
                    'text' => 'dashboard.attendance_sheet',
                    'route' => 'attendance.index',
                ],
            ],
        ],
        [
            'text' => 'dashboard.reports',
            'icon' => 'nav-icon fas fa-chart-bar',
            'can' => ['reports.member_information', 'reports.payment_transactions', 'reports.attendance'],
            'header' => false,
            'submenu' => [
                [
                    'text' => 'dashboard.member_information',
                    'route' => 'reports.member_information',
                ],
                [
                    'text' => 'dashboard.payment_transactions',
                    'route' => 'reports.payment_transactions',
                ],
                [
                    'text' => 'dashboard.attendance',
                    'route' => 'reports.attendance',
                ],
            ],
        ],
        [
            'text' => 'dashboard.settings',
            'header' => true,
        ],
        [
            'text' => 'dashboard.users',
            'icon' => 'nav-icon fas fa-users',
            'can' => ['user.index', 'user.create', 'user.index', 'user.edit'],
            'header' => false,
            'submenu' => [
                [
                    'text' => 'Add User',
                    'route' => 'user.create',
                ],
                [
                    'text' => 'View Users',
                    'route' => 'user.index',
                ],
            ],
        ],
        [
            'text' => 'dashboard.role',
            'icon' => 'nav-icon fas fa-user-shield',
            'can' => ['user_role.index', 'user_role.create', 'user_role.edit'],
            'header' => false,
            'submenu' => [
                [
                    'text' => 'dashboard.add_role',
                    'route' => 'user_role.create',
                ],
                [
                    'text' => 'dashboard.view_roles',
                    'route' => 'user_role.index',
                ],
            ],
        ],
        [
            'text' => 'dashboard.settings',
            'icon' => 'nav-icon fas fa-cogs',
            'route' => 'settings.index',
            'can' => ['settings.index'],
            'header' => false,
        ],
    ],
];